/*
 * Decompiled with CFR 0.152.
 */
package com.tp_link.eap.monitor.monitor.service.impl;

import com.tp_link.eap.domain.eap.AlertInfo;
import com.tp_link.eap.domain.global.OperationResult;
import com.tp_link.eap.domain.ui.Grid;
import com.tp_link.eap.domain.ui.QueryData;
import com.tp_link.eap.domain.ui.QueryFilter;
import com.tp_link.eap.domain.ui.QueryPage;
import com.tp_link.eap.domain.ui.QuerySort;
import com.tp_link.eap.monitor.monitor.repo.AlertRepository;
import com.tp_link.eap.monitor.monitor.service.a;
import com.tp_link.eap.multicontrol.ControlType;
import com.tp_link.eap.multicontrol.OperationResponse;
import com.tp_link.eap.multicontrol.ResErrorCode;
import com.tp_link.eap.util.a.b;
import com.tp_link.eap.util.a.e;
import com.tp_link.eap.util.l;
import java.io.Serializable;
import java.util.Date;
import java.util.List;
import net.sf.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.mongodb.core.MongoTemplate;
import org.springframework.data.mongodb.core.query.Criteria;
import org.springframework.data.mongodb.core.query.Query;
import org.springframework.data.mongodb.core.query.Update;
import org.springframework.stereotype.Component;
import org.springframework.util.CollectionUtils;

@Component(value="alertService")
public class AlertService
extends com.tp_link.eap.i.a.a<AlertInfo>
implements a {
    private final Logger a = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private AlertRepository b;
    @Autowired
    private MongoTemplate c;

    @Override
    public List<AlertInfo> getAll() {
        return com.tp_link.eap.util.a.a.a((Iterable)this.b.findAll());
    }

    @Override
    public boolean addAlert(AlertInfo alert) {
        if (null == alert) {
            return false;
        }
        this.c();
        if (alert.getApMac() != null) {
            String string = com.tp_link.eap.d.b.e((String)alert.getApMac());
            alert.setSite(string);
        } else {
            alert.setSite(com.tp_link.eap.d.b.a());
        }
        this.b.save(alert);
        return true;
    }

    @Override
    public boolean addAlerts(List<AlertInfo> alerts) {
        if (CollectionUtils.isEmpty(alerts)) {
            return false;
        }
        this.b.save(alerts);
        this.c();
        return true;
    }

    private OperationResponse a(String string) {
        if (null == string) {
            return com.tp_link.eap.util.e.aZ;
        }
        AlertInfo alertInfo = (AlertInfo)this.b.findOne((Serializable)((Object)string));
        if (null == alertInfo) {
            return new OperationResponse(ResErrorCode.bs);
        }
        alertInfo.setArchived(Boolean.valueOf(true));
        this.b.save(alertInfo);
        return new OperationResponse(ResErrorCode.a, "Archive successfully.", null);
    }

    @Override
    public OperationResponse archiveAlert(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("alertId");
        if (e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.a(string);
    }

    private OperationResponse a() {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"archived").is((Object)false));
        query.addCriteria(Criteria.where((String)"site").is((Object)com.tp_link.eap.d.b.a()));
        Update update = new Update();
        update.set("archived", (Object)true);
        this.c.updateMulti(query, update, AlertInfo.class);
        return new OperationResponse(ResErrorCode.a, "Archive all successfully.", null);
    }

    @Override
    public OperationResponse archiveAllAlert(ControlType controlType, JSONObject reqObj) {
        return this.a();
    }

    private OperationResponse b(String string) {
        if (null == string) {
            return com.tp_link.eap.util.e.aZ;
        }
        try {
            this.b.delete((Serializable)((Object)string));
            return new OperationResponse(ResErrorCode.a, "Delete alert message successfully.", null);
        }
        catch (Exception exception) {
            return com.tp_link.eap.util.e.bg;
        }
    }

    @Override
    public OperationResponse deleteAlert(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        String string = jSONObject.optString("alertId");
        if (e.a((String)string)) {
            return new OperationResponse(ResErrorCode.d);
        }
        return this.b(string);
    }

    private OperationResponse b() {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"archived").is((Object)true));
        query.addCriteria(Criteria.where((String)"site").is((Object)com.tp_link.eap.d.b.a()));
        this.c.remove(query, AlertInfo.class);
        return new OperationResponse(ResErrorCode.a, "Delete all archived alerts successfully.", null);
    }

    @Override
    public OperationResponse deleteAllArchivedAlert(ControlType controlType, JSONObject reqObj) {
        return this.b();
    }

    @Override
    public void deleteBySite() {
        List<AlertInfo> list = this.b.findBySite(com.tp_link.eap.d.b.a());
        if (!CollectionUtils.isEmpty(list)) {
            this.b.delete(list);
        }
    }

    @Override
    public void deleteByApAndSite(String apMac, String site) {
        List<AlertInfo> list = this.b.findByApMacAndSite(apMac, site);
        if (!CollectionUtils.isEmpty(list)) {
            this.b.delete(list);
        }
    }

    @Override
    public OperationResult clearAlerts(Date date) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"time").lt((Object)date));
        query.addCriteria(Criteria.where((String)"archived").is((Object)true));
        this.c.remove(query, AlertInfo.class);
        return com.tp_link.eap.util.e.bc;
    }

    @Override
    public List<AlertInfo> getAlertsAfterDate(Date date) {
        Query query = new Query();
        query.addCriteria(Criteria.where((String)"time").gt((Object)date));
        return this.c.find(query, AlertInfo.class);
    }

    @Override
    public void deleteAll() {
        this.b.deleteAll();
    }

    public List<AlertInfo> getList(QueryPage queryPage) {
        return this.getList(queryPage, null, null, null);
    }

    public List<AlertInfo> getList(QueryPage queryPage, QuerySort querySort) {
        return this.getList(queryPage, querySort, null, null);
    }

    public List<AlertInfo> getList(QueryPage queryPage, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.getList(queryPage, null, filters, searchFilters);
    }

    public List<AlertInfo> getList(QueryPage queryPage, QuerySort querySort, List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.b.getByFilters(queryPage, querySort, filters, searchFilters);
    }

    public long count(List<QueryFilter> filters, List<QueryFilter> searchFilters) {
        return this.b.countByFilters(filters, searchFilters);
    }

    @Override
    public OperationResponse getGridAlerts(ControlType controlType, JSONObject reqObj) {
        JSONObject jSONObject = reqObj.optJSONObject("params");
        if (jSONObject == null) {
            this.a.warn("Invalid request, params is null");
            return com.tp_link.eap.util.e.aZ;
        }
        QueryData queryData = (QueryData)com.tp_link.eap.util.a.b.a((Object)jSONObject, QueryData.class);
        String string = queryData.getSortName();
        if (e.a((String)string)) {
            queryData.setSortName("time");
            queryData.setSortOrder("desc");
        }
        Grid grid = new Grid(queryData);
        Boolean bl = (Boolean)queryData.getFilters().get("archived");
        if (bl != null) {
            grid.initFilters("archived", (Object)bl, QueryFilter.FilterType.eq);
        }
        grid.initSearch(queryData.getSearchKey(), new String[]{"apMac", "model", "msg"});
        long l2 = this.count(grid);
        grid.setTotalRows(l2);
        List list = this.getList(grid);
        grid.setData(list);
        return new OperationResponse(ResErrorCode.a, (Object)grid);
    }

    private void c() {
        if (l.b()) {
            return;
        }
        long l2 = this.b.count();
        while (l2 != 0L && l2 >= 11000L) {
            this.a.info("alert num {} has reached maximum", (Object)l2);
            this.b.clearTop(1000, "time");
            l2 = this.b.count();
            this.a.info("after clear, alert num is {}", (Object)l2);
        }
    }
}

